/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.gashapon;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.gashapon.NeowEvent;
import com.megacrit.cardcrawl.rooms.AbstractRoom;

public class GashaponRoom
extends AbstractRoom {
    public GashaponRoom(boolean isDone) {
        this.phase = AbstractRoom.RoomPhase.EVENT;
        this.event = new NeowEvent(isDone);
        this.event.onEnterRoom();
    }

    @Override
    public void onPlayerEntry() {
        AbstractDungeon.overlayMenu.proceedButton.hide();
    }

    @Override
    public void update() {
        super.update();
        if (!AbstractDungeon.isScreenUp) {
            this.event.update();
        }
        if (this.event.waitTimer == 0.0f && !this.event.hasFocus && this.phase != AbstractRoom.RoomPhase.COMBAT) {
            this.phase = AbstractRoom.RoomPhase.COMPLETE;
            this.event.reopen();
        }
    }

    @Override
    public AbstractCard.CardRarity getCardRarity(int roll) {
        int rareRate = AbstractDungeon.player.hasRelic("Nloth's Gift") ? 9 : 3;
        if (roll < rareRate) {
            if (AbstractDungeon.player.hasRelic("Nloth's Gift") && roll > 3) {
                AbstractDungeon.player.getRelic("Nloth's Gift").flash();
            }
            return AbstractCard.CardRarity.RARE;
        }
        if (roll < 40) {
            return AbstractCard.CardRarity.UNCOMMON;
        }
        return AbstractCard.CardRarity.COMMON;
    }

    @Override
    public void render(SpriteBatch sb) {
        super.render(sb);
        this.event.render(sb);
    }

    @Override
    public void renderAboveTopPanel(SpriteBatch sb) {
        super.renderAboveTopPanel(sb);
        if (this.event != null) {
            this.event.renderAboveTopPanel(sb);
        }
    }

    public static enum GashaContent {
        GOLD,
        HP,
        POTION,
        RELIC,
        CARD,
        UNLOCK_RELIC,
        UNLOCK_CARD;

    }
}

